/*
 * Copyright (C) 2007 iZsh 
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License version 2 for more details
 */
using namespace std;
#include <iostream>
#include <CoreFoundation/CoreFoundation.h>
#include "MobileDevice.h"
#include "activation.h"
#include "connect.h"

void DeviceNotificationCallbackState(am_device_notification_callback_info * Info)
{
  am_device *dev = Info->dev;
  
  cout << "Found iPhone Device: " << Info->msg << endl;
  if (!Connect(dev)) {
    return;
  }
  
  PrintActivationState(dev, "State: ");

  Disconnect(dev);
  CFRunLoopStop(CFRunLoopGetCurrent());
}

void DeviceNotificationCallbackDeactivate(am_device_notification_callback_info * Info)
{
  am_device *dev = Info->dev;
  
  cout << "Found iPhone Device: " << Info->msg << endl;
  if (!Connect(dev)) {
    return;
  }

  Deactivate(dev);

  Disconnect(dev);
  CFRunLoopStop(CFRunLoopGetCurrent());
}


void PrintActivationState(am_device *Device, const string & Str)
{
  AMDeviceRemoveValue(Device, 0, CFSTR("ActivationStateAcknowledged"));
  CFStringRef activation_state = AMDeviceCopyValue(Device, NULL, CFSTR("ActivationState"));
  if (activation_state == NULL) {
    cerr << "Could not retrieve the Activation State" << endl;
  }
  cout << Str << flush;
  CFShow(activation_state);
  AMDeviceRemoveValue(Device, 0, CFSTR("ActivationStateAcknowledged"));
  CFRelease(activation_state);  
}

void Deactivate(am_device *Device)
{
  PrintActivationState(Device, "Current State: ");
  AMDeviceDeactivate(Device);
  PrintActivationState(Device, "New State: ");
}

void Activate(am_device *Device, CFDictionaryRef Request)
{
  cout << "Deactivating..." << endl;
  Deactivate(Device);
  cout << "Activating..." << endl;
  AMDeviceActivate(Device, Request);
  PrintActivationState(Device, "New State: ");
}
