/*
 * Copyright (C) 2007 iZsh 
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License version 2 for more details
 */
using namespace std;
#include <iostream>

#include "MobileDevice.h"
#include "connect.h"
#include "afc.h"

afc_connection * AFCOpen(am_device * Dev)
{
  afc_connection *hAFC;
  // Let's try the backdoor first
  if (AMDeviceStartService(Dev, CFSTR("com.apple.afc2"), &hAFC, NULL) != MDERR_OK
      && AMDeviceStartService(Dev, AMSVC_AFC, &hAFC, NULL) != MDERR_OK) {
    return NULL;
  }
  Disconnect(Dev);

  if (AFCConnectionOpen(hAFC, 0, &hAFC) != MDERR_OK) {
    return NULL;
  }
  return hAFC;
}

bool AFCClose(afc_connection * hAFC)
{
  if (AFCConnectionClose(hAFC) != MDERR_OK)
    return false;
  return true;
}

// this function is taken (and rewritten) from the iPhoneInterface, orignal author unknown
size_t AFCGetFileSize(afc_connection * hAFC, const string & FilePath)
{
  afc_dictionary *file_info;
  if (AFCFileInfoOpen(hAFC, FilePath.c_str(), &file_info) != MDERR_OK)
    return 0;

  char *key = NULL;
  char *val = NULL;
  AFCKeyValueRead(file_info, &key, &val);
  while (key && val) {
    size_t size = 0;
    if (!strcmp(key, "st_size")) {
      sscanf(val, "%lu", &size);
      AFCKeyValueClose(file_info);
      return size;
    }
  }
  
  AFCKeyValueClose(file_info);
  return 0;
}

bool AFCOpenFile(afc_connection * hAFC,
                 const string &FilePath,
                 const FileAccess_t FileAccess,
                 afc_file_ref & AFCFileRef)
{
  afc_file_ref file;

  if (AFCFileRefOpen(hAFC, FilePath.c_str(), FileAccess, &file) != MDERR_OK)
    return false;
  AFCFileRef = file;
  return true;
}

bool AFCCloseFile(afc_connection * hAFC, afc_file_ref File)
{
  if (AFCFileRefClose(hAFC, File) != MDERR_OK)
    return false;
  return true;
}

char * AFCReadFile(afc_connection * hAFC, afc_file_ref File, size_t Size)
{
  char * buffer = new char[Size];

  size_t total_read_size = 0;
  while (total_read_size < Size) {
    size_t read_size = Size - total_read_size;
    if (AFCFileRefRead(hAFC, File, buffer + total_read_size, &read_size) != MDERR_OK
        || read_size == 0) {
      delete[] buffer;
      return NULL;
    }
    total_read_size += read_size;
  }

  return buffer;
}

bool AFCWriteFile(afc_connection * hAFC, afc_file_ref File, const char * Buffer, size_t Size)
{
  if (AFCFileRefWrite(hAFC, File, Buffer, Size) != MDERR_OK)
    return false;
  return true;
}

bool AFCUploadFile(afc_connection * hAFC,
                   const string & LocalFilePath,
                   const string & RemoteFilePath)
{
  // Open the local file
  FILE *fp = fopen(LocalFilePath.c_str(), "r");
  if (!fp) {
    perror(LocalFilePath.c_str());
    return false;
  }
  // Compute the size
  fseek(fp , 0 , SEEK_END);
  size_t size = ftell(fp);
  rewind(fp);
  // Read the file
  char * buffer;
  buffer = new char[size];
  fread(buffer, size, 1, fp);
  fclose(fp);
  
  // Open the remote file
  afc_file_ref remote_file;
  if (!AFCOpenFile(hAFC, RemoteFilePath, AFC_Write, remote_file)) {
    cerr << "Could not open the remote file " << RemoteFilePath << endl;
    return false;
  }
  // Write it
  if (!AFCWriteFile(hAFC, remote_file, buffer, size)) {
    cerr << "Error while writing the remote file" << endl;
    return false;
  }
  delete[] buffer;
  // And close it
  if (!AFCCloseFile(hAFC, remote_file)) {
    cerr << "Error while closing the remote file" << endl;
    return false;
  }
  
  return true;
}

bool AFCDownloadFile(afc_connection * hAFC,
                     const string & LocalFilePath,
                     const string & RemoteFilePath)
{
  // Get the remote size
  size_t size = AFCGetFileSize(hAFC, RemoteFilePath.c_str());
  if (size == 0) {
    cerr << "Error while retrieving the remote file size" << endl;
    return false;
  }
  
  // Open and read
  afc_file_ref remote_file;
  if (!AFCOpenFile(hAFC, RemoteFilePath, AFC_Read, remote_file)) {
    cerr << "Could not open the remote file " << RemoteFilePath << endl;
    return false;
  }
  char * buffer = AFCReadFile(hAFC, remote_file, size);
  if (buffer == NULL) {
      cerr << "Could not read data from the remote file" << endl;
      return false;
  }
  if (!AFCCloseFile(hAFC, remote_file)) {
    cerr << "Error while trying to close the remote file" << endl;
    return false;
  }

  // And finally... Write it
  FILE * fp = fopen(LocalFilePath.c_str(), "w");
  if (!fp) {
    perror(LocalFilePath.c_str());
    return false;
  }  
  fwrite(buffer, size, 1, fp);
  fclose(fp);
  delete[] buffer;

  return true;
}
