/*
 * Copyright (C) 2007 iZsh 
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License version 2 for more details
 */
#ifndef AFC_H__
#define AFC_H__

enum FileAccess_t
{
  AFC_Read = 2,
  AFC_Write = 3
};

afc_connection * AFCOpen(am_device * Dev);
bool AFCClose(afc_connection * hAFC);

size_t AFCGetFileSize(afc_connection * hAFC, const string & FilePath);

bool AFCOpenFile(afc_connection * hAFC,
                 const string &FilePath,
                 const FileAccess_t FileAccess,
                 afc_file_ref & AFCFileRef);

bool AFCCloseFile(afc_connection * hAFC, afc_file_ref File);

char * AFCReadFile(afc_connection * hAFC, afc_file_ref File, size_t Size);

bool AFCWriteFile(afc_connection * hAFC, afc_file_ref File, const char * Buffer, size_t Size);

bool AFCUploadFile(afc_connection * hAFC,
                   const string & LocalFilePath,
                   const string & RemoteFilePath);

bool AFCDownloadFile(afc_connection * hAFC,
                     const string & LocalFilePath,
                     const string & RemoteFilePath);

#endif

