/*
 * Copyright (C) 2007 iZsh 
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License version 2 for more details
 */
using namespace std;
#include <iostream>

#include <CoreFoundation/CoreFoundation.h>

#include "pem.h"

#include "MobileDevice.h"
#include "auto.h"
#include "connect.h"
#include "activation.h"
#include "activationrecord.h"

// Gosh that's ugly
EVP_PKEY * gl_PKey = NULL;

static void DeviceNotificationCallbackActivate(am_device_notification_callback_info * Info)
{
  char buffer[4096];
  am_device *dev = Info->dev;

  cout << "Found iPhone Device: " << Info->msg << endl;
  if (!Connect(dev)) {
    return;
  }

  // Retrieve the values
  CFStringRef deviceid = AMDeviceCopyDeviceIdentifier(dev);
  if (deviceid == NULL) {
    cerr << "Could not retrieve the DeviceID" << endl;
  }
  CFStringRef imei = AMDeviceCopyValue(dev, NULL, CFSTR("InternationalMobileEquipmentIdentity"));
  if (imei == NULL) {
    cerr << "Could not retrieve the IMEI" << endl;
  }
  CFStringRef iccid = AMDeviceCopyValue(dev, NULL, CFSTR("IntegratedCircuitCardIdentity"));
  if (iccid == NULL) {
    cerr << "Could not retrieve the ICCID (make sure the SIM is inserted)" << endl;
  }
  if (deviceid == NULL || imei == NULL || iccid == NULL) {
    CFRunLoopStop(CFRunLoopGetCurrent());
    return;
  }

  // Convert to STL strings
  CFStringGetCString(deviceid, buffer, 4096, kCFStringEncodingASCII);
  string deviceid_str(buffer);
  CFRelease(deviceid);
  CFStringGetCString(imei, buffer, 4096, kCFStringEncodingASCII);
  string imei_str(buffer);
  CFRelease(imei);
  CFStringGetCString(iccid, buffer, 4096, kCFStringEncodingASCII);
  string iccid_str(buffer);
  CFRelease(iccid);
  
  cout << "DeviceID: " << deviceid_str << endl;
  cout << "IMEI: " << imei_str << endl;
  cout << "ICCID: " << iccid_str << endl;

  CFDictionaryRef activation_record = GenerateActivationRecord(gl_PKey, deviceid_str, imei_str, iccid_str);
  if (activation_record == NULL) {
    cerr << "Unkown error" << endl;
    exit(1);
  }

  Activate(dev, activation_record);
  CFRelease(activation_record);

  Disconnect(dev);
  CFRunLoopStop(CFRunLoopGetCurrent());
}

void AutomaticActivation(char * Filename)
{
  ERR_load_crypto_strings();
  EVP_PKEY * pkey = LoadPEM(Filename);
  gl_PKey = pkey;

  am_device_notification *notif;
  AMDeviceNotificationSubscribe(DeviceNotificationCallbackActivate, 0, 0, 0, &notif);
  cout << "Waiting for iPhone..." << endl;
  CFRunLoopRun();
}
