/*
 * Copyright (C) 2007 iZsh 
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License version 2 for more details
 */
using namespace std;
#include <iostream>

#include "MobileDevice.h"
#include "connect.h"
#include "afc.h"
#include "backup.h"

// Gosh that's ugly
string gl_File;

static void DeviceNotificationCallbackBackup(am_device_notification_callback_info * Info)
{
  am_device *dev = Info->dev;
  
  cout << "Found iPhone Device: " << Info->msg << endl;
  if (!Connect(dev)) {
    cerr << "Could not connect to the device" << endl;
    return;
  }

  afc_connection *hAFC = AFCOpen(dev);
  if (hAFC == NULL) {
    cerr << "Error while starting/opening the AFC service" << endl;
    return;
  }

  // Let's find the activation record
  string activation_record_path("/var/root/Library/Lockdown/activation_record.plist");
  if (!AFCGetFileSize(hAFC, activation_record_path)) {
    cerr << "Could not locate the activation record on the iPhone..." << endl;
    cerr << "Are you sure your iPhone is activated?" << endl;
    AFCClose(hAFC);
    CFRunLoopStop(CFRunLoopGetCurrent());
    return;
  }

  if (AFCDownloadFile(hAFC, gl_File, activation_record_path))
    cout << "Retrieving file... OK" << endl;
  
  if (!AFCClose(hAFC)) {
    cerr << "Error while closing the AFC connection" << endl;
    return;
  }

  CFRunLoopStop(CFRunLoopGetCurrent());
}

void BackupActivationRecord(const string & File)
{
  gl_File = File;

  am_device_notification *notif;
  AMDeviceNotificationSubscribe(DeviceNotificationCallbackBackup, 0, 0, 0, &notif);
  cout << "Waiting for iPhone..." << endl;
  CFRunLoopRun();
}
