/*
 * Copyright (C) 2007 iZsh 
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License version 2 for more details
 */
using namespace std;
#include <iostream>

#include "MobileDevice.h"
#include "connect.h"

bool Connect(am_device * Device)
{
  cout << "Connection... " << flush;

  if(AMDeviceConnect(Device)) {
    cerr << endl << "Could not connect to the device" << endl;
    return false;
  }
  // Pairing
  if(!AMDeviceIsPaired(Device)) {
    if (AMDevicePair(Device)) {
      cerr << endl << "Could not pair the device" << endl;
      return false;
    }
  } else if (AMDeviceValidatePairing(Device)) {
    cerr << endl << "Invalid pairing, attempting to pair again..." << endl;
    if (AMDevicePair(Device)) {
      cerr << endl << "Could not pair the device" << endl;
      return false;
    }
  }
  // Session
  if(AMDeviceStartSession(Device)) {
    cerr << endl << "Could not start a session" << endl;
    return false;
  }
  
  cout << "OK" << endl;
  
  return true;
}

void Disconnect(am_device * Device)
{
  AMDeviceStopSession(Device);
  AMDeviceDisconnect(Device);
}
