/*
 * Copyright (C) 2007 iZsh 
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License version 2 for more details
 */
using namespace std;

#include <iostream>
#include <CoreFoundation/CoreFoundation.h>

#include "MobileDevice.h"

#include <iostream>
#include <fstream>
#include <string>
#include "pem.h"
#include "accounttoken.h"
#include "activationrecord.h"
#include "auto.h"
#include "activation.h"
#include "xml.h"
#include "backup.h"

void State(int Argc, char * const Argv[]);
void Deactivate(int Argc, char * const Argv[]);
void Backup(int Argc, char * const Argv[]);
void AutomaticActivation(int Argc, char * const Argv[]);
void GenerateActivationXML(int Argc, char * const Argv[]);
void FromXML(int Argc, char * const Argv[]);

typedef void (*CmdFct)(int Argc, char * const Argv[]);
struct Cmd
{
  const char * Name;
  CmdFct Fct;
  const char * Help;
};

Cmd Cmds[] =
  {
    {"--state", State, ""},
    {"--deactivate", Deactivate, ""},
    {"--backup", Backup, "<filename>"},
    {"--automatic", AutomaticActivation, "<private key file>"},
    {"--generate", GenerateActivationXML, "<private key file> <DeviceID> <IMEI> <ICCID> <out_filename>"},
    {"--fromxml", FromXML, "<filename>"},
  };

const int NumberOfCommands = sizeof (Cmds) / sizeof (Cmd);

// Autogenerated usage for a lazy dev ;)
void Usage(const string & Tool)
{
  cout << "iASign v0.2 by iZsh" << endl
  << "Activation Signature tool" << endl << endl
  << "Usage:" << endl;

  for (int i = 0; i < NumberOfCommands; ++i)
    cout << Tool << " " << Cmds[i].Name << " " << Cmds[i].Help << endl;

  exit(1);
}

void State(int Argc, char * const Argv[])
{
  am_device_notification *notif;
  AMDeviceNotificationSubscribe(DeviceNotificationCallbackState, 0, 0, 0, &notif);
  cout << "Waiting for iPhone..." << endl;
  CFRunLoopRun();  
}

void Deactivate(int Argc, char * const Argv[])
{
  am_device_notification *notif;
  AMDeviceNotificationSubscribe(DeviceNotificationCallbackDeactivate, 0, 0, 0, &notif);
  cout << "Waiting for iPhone..." << endl;
  CFRunLoopRun();  
}

void Backup(int Argc, char * const Argv[])
{
  if (Argc != 3)
    Usage(Argv[0]);
  
  BackupActivationRecord(Argv[2]);
}

void AutomaticActivation(int Argc, char * const Argv[])
{
  if (Argc != 3)
    Usage(Argv[0]);

  const int argvbase = 2;

  AutomaticActivation(Argv[argvbase + 0]);
}

void GenerateActivationXML(int Argc, char * const Argv[])
{
  if (Argc != 7)
    Usage(Argv[0]);
  const int argvbase = 2;
  ERR_load_crypto_strings();
  EVP_PKEY * pkey = LoadPEM(Argv[argvbase + 0]);

  string deviceid_str(Argv[argvbase + 1]);
  string imei_str(Argv[argvbase + 2]);
  string iccid_str(Argv[argvbase + 3]);
  string filename(Argv[argvbase + 4]);

  CFDictionaryRef request = GenerateActivationRecord(pkey, deviceid_str, imei_str, iccid_str);
  if (request == NULL) {
    cerr << "Unkown error" << endl;
    exit(1);
  }
  SaveToXML(filename, request);

  CFRelease(request);
}

void FromXML(int Argc, char * const Argv[])
{
  if (Argc != 3)
    Usage(Argv[0]);

  ActivateFromXML(Argv[2]);
}

int main (int argc, char * const argv[])
{
  if (argc <= 1)
    Usage(argv[0]);

  string cmd(argv[1]);
  // Automated command dispatching
  CmdFct cmdfct = NULL;
  for (int i = 0; i < NumberOfCommands && cmdfct == NULL; ++i) {
    if (cmd == Cmds[i].Name)
      cmdfct = Cmds[i].Fct;
  }
  if (cmdfct == NULL)
    Usage(argv[0]);
  cmdfct(argc, argv);
  
  return 0;
}
