/*
 * Copyright (C) 2007 iZsh 
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License version 2 for more details
 */
using namespace std;
#include <iostream>
#include <CoreFoundation/CoreFoundation.h>
#include "MobileDevice.h"
#include "connect.h"
#include "activation.h"
#include "xml.h"

// Gosh that's ugly
CFDictionaryRef gl_ActivationRecord = NULL;

static void DeviceNotificationCallbackActivate(am_device_notification_callback_info * Info)
{
  am_device *dev = Info->dev;
  
  cout << "Found iPhone Device: " << Info->msg << endl;
  if (!Connect(dev)) {
    return;
  }

  Activate(dev, gl_ActivationRecord);
  CFRelease(gl_ActivationRecord);
  
  Disconnect(dev);
  CFRunLoopStop(CFRunLoopGetCurrent());
}

void SaveToXML(const string & Filename, CFDictionaryRef Dict)
{
  CFURLRef file = CFURLCreateFromFileSystemRepresentation (NULL,
                                                           reinterpret_cast<const UInt8*>(Filename.c_str()),
                                                           Filename.length(),
                                                           false /* isDirectory */);
  
  CFDataRef xml = CFPropertyListCreateXMLData(NULL, Dict);
  
  SInt32 errorCode;
  if (!CFURLWriteDataAndPropertiesToResource(file, xml, NULL, &errorCode)) {
    cout << "Error code: " << errorCode << endl;
  }
  
  CFRelease(xml);
  CFRelease(file);
}

void ActivateFromXML(const string & File)
{
  CFURLRef fileURL = CFURLCreateFromFileSystemRepresentation (NULL,
                                                              reinterpret_cast<const UInt8*>(File.c_str()),
                                                              File.length(),
                                                              false /* isDirectory */);
  if (fileURL == NULL) {
    cerr << "Could not load " << File << endl;
    return;
  }
  
  // Read the XML file.  
  Boolean status;
  CFDataRef resourceData;
  SInt32 errorCode;
  status = CFURLCreateDataAndPropertiesFromResource(kCFAllocatorDefault,
                                                    fileURL,
                                                    &resourceData,            // place to put file data
                                                    NULL,
                                                    NULL,
                                                    &errorCode);
  if (!status) {
    cerr << "Could not load " << File << endl;
    return;
  }

  // Reconstitute the dictionary using the XML data.
  CFStringRef errorString;
  CFPropertyListRef propertyList = CFPropertyListCreateFromXMLData(kCFAllocatorDefault,
                                                                  resourceData,
                                                                  kCFPropertyListImmutable,
                                                                  &errorString);
  if (errorString != NULL) {
    cerr << "Error while reading the XML file: " << flush;
    CFShow(errorString);
    return;
  }
  gl_ActivationRecord = (CFDictionaryRef)propertyList;

  am_device_notification *notif;
  AMDeviceNotificationSubscribe(DeviceNotificationCallbackActivate, 0, 0, 0, &notif);
  cout << "Waiting for iPhone..." << endl;
  CFRunLoopRun();  

  CFRelease( resourceData );
}